package fstop;

import java.sql.Connection;
//import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class CategoryDAO {

	public List getCategories() throws DAOException
	{
		System.out.println("executing CategoryDAO.getCategories");
		
		ArrayList list = new ArrayList();
		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();
			Statement s = c.createStatement();
			ResultSet rs = s.executeQuery("SELECT * FROM categories ORDER BY category");
			Category category;
			while (rs.next())
			{
				category = new Category();
				category.setCategoryId(rs.getInt("CATEGORYID"));
				category.setCategory(rs.getString("CATEGORY"));
				list.add(category);
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new DAOException(e);
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}

		return list;
	}
	
}
