package fstop;

import java.sql.Connection;
//import java.sql.PreparedStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class OrderDAO {

	public int create(Order order) throws DAOException
	{

		System.out.println("executing OrderDAO.create: " + order.getCustomerName());
		
		int orderId;
		
		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();
			PreparedStatement ps = c.prepareStatement(
				"INSERT INTO orders " +
				"(customerName, email) " +
				"VALUES (?, ?)");
			ps.setString(1, order.getCustomerName());
			ps.setString(2, order.getEmail());
			ps.execute();
			Statement s = c.createStatement();
			// HSQLDB Syntax to get the identity (photoId) of inserted row
			ResultSet rs = s.executeQuery("CALL IDENTITY()");
			rs.next();
			orderId=rs.getInt(1);
			
			//Insert order line items
			ArrayList photos = (ArrayList)order.getLineItems();
			for (int i=0; i<photos.size(); i++) {
				Photo photo = (Photo)photos.get(i);
				ps = c.prepareStatement(
						"INSERT INTO lineitems " +
						"(orderId, photoId) " +
						"VALUES (?, ?)");
					ps.setInt(1, photo.getCategoryId());
					ps.setInt(2, photo.getPhotoId());
					ps.execute();
			}
			
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new DAOException(e.getMessage());
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}
		return orderId;
	}


	
}
