package fstop;

import java.util.Iterator;
import java.util.List;

import flex.data.ChangeObject;
//import flex.data.DataSyncException;

public class PhotoAssembler
{

	public List loadPhotos()
	{
		System.out.println("loadPhotos()");
		PhotoDAO dao = new PhotoDAO();
		return dao.getPhotos();
	}

	public List loadPhotos(Integer categoryId)
	{
		System.out.println("loadPhotos(int)");
		PhotoDAO dao = new PhotoDAO();
		return dao.getPhotos(categoryId.intValue());
	}

	public List syncPhotos(List changes)
	{
		Iterator iterator = changes.iterator();
		ChangeObject co;
		while (iterator.hasNext())
		{
			co = (ChangeObject) iterator.next();
			if (co.isCreate())
			{
				co = doCreate(co);
			}
			else if (co.isUpdate())
			{
				doUpdate(co);
			}
			else if (co.isDelete())
			{
				doDelete(co);
			}
		}
		return changes;
	}

	private ChangeObject doCreate(ChangeObject co)
	{
		PhotoDAO dao = new PhotoDAO();
		Photo photo = dao.create((Photo) co.getNewVersion());
		co.setNewVersion(photo);
		return co;
	}

	private void doUpdate(ChangeObject co)
	{
		/*PhotoDAO dao = new PhotoDAO();
		try
		{
			dao.update((Photo) co.getNewVersion(), (Photo) co.getPreviousVersion());
		}
		catch (ConcurrencyException e)
		{
			System.err.println("*** Throwing DataSyncException when trying to update contact id=" + ((Photo) co.getNewVersion()).getPhotoId() );
			throw new DataSyncException(co);
		}*/
	}

	private void doDelete(ChangeObject co)
	{
		/*PhotoDAO dao = new PhotoDAO();
		try
		{
			dao.delete((Photo) co.getPreviousVersion());
		}
		catch (ConcurrencyException e)
		{
			System.err.println("*** Throwing DataSyncException when trying to delete photo id=" + ((Photo) co.getNewVersion()).getPhotoId() );
			throw new DataSyncException(co);
		}*/
		
	}

}