package fstop;

import java.sql.Connection;
//import java.sql.PreparedStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class PhotoDAO {

	public List getPhotos() throws DAOException
	{
		System.out.println("executing PhotoDAO.getPhotos");
		
		ArrayList list = new ArrayList();
		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();
			Statement s = c.createStatement();
			ResultSet rs = s.executeQuery("SELECT photos.*, categories.category " +
					" FROM photos, categories" +
					" WHERE photos.categoryid = categories.categoryid" +
					" ORDER BY filename");
			Photo photo;
			while (rs.next())
			{
				photo = new Photo();
				photo.setPhotoId(rs.getInt("PHOTOID"));
				photo.setFilename(rs.getString("FILENAME"));
				photo.setDesc(rs.getString("DESC"));
				photo.setCategory(rs.getString("CATEGORY"));
				photo.setCategoryId(rs.getInt(("CATEGORYID")));
				photo.setPhotographer(rs.getString("PHOTOGRAPHER"));
				list.add(photo);
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new DAOException(e);
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}

		return list;
	}
	
	public List getPhotos(int categoryId) throws DAOException
	{
		System.out.println("executing PhotoDAO.getPhotos");
		
		ArrayList list = new ArrayList();
		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();
			Statement s = c.createStatement();
			ResultSet rs = s.executeQuery("SELECT photos.*, categories.category " +
					" FROM photos, categories" +
					" WHERE photos.categoryid = categories.categoryid" +
					" AND photos.categoryid = " + categoryId +
					" ORDER BY filename");
			Photo photo;
			while (rs.next())
			{
				photo = new Photo();
				photo.setPhotoId(rs.getInt("PHOTOID"));
				photo.setFilename(rs.getString("FILENAME"));
				photo.setDesc(rs.getString("DESC"));
				photo.setCategory(rs.getString("CATEGORY"));
				photo.setCategoryId(rs.getInt(("CATEGORYID")));
				photo.setPhotographer(rs.getString("PHOTOGRAPHER"));
				list.add(photo);
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new DAOException(e);
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}

		return list;
	}
	
	public Photo create(Photo photo) throws DAOException
	{
		
		System.out.println("executing PhotoDAO.create: " + photo.getFilename());
		
		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();
			
			PreparedStatement ps = c.prepareStatement("SELECT COUNT(*) FROM photos " +
					"WHERE filename=?");
			ps.setString(1, photo.getFilename());
			ResultSet rs = ps.executeQuery();
			rs.next();
			System.out.println("count: " + rs.getInt(1));
			if (rs.getInt(1) != 0) {
				throw(new DAOException("That photo is already in the database"));
			}
			
			ps = c.prepareStatement(
				"INSERT INTO photos " +
				"(filename, photographer, desc, categoryid) " +
				"VALUES (?, ?, ?, ?)");
			ps.setString(1, photo.getFilename());
			ps.setString(2, photo.getPhotographer());
			ps.setString(3, photo.getDesc());
			ps.setInt(4, photo.getCategoryId());
			ps.execute();
			Statement s = c.createStatement();
			// HSQLDB Syntax to get the identity (photoId) of inserted row
			rs = s.executeQuery("CALL IDENTITY()");
			rs.next();
			photo.setPhotoId(rs.getInt(1));
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new DAOException(e.getMessage());
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}
		return photo;
	}


	
}
